# Test Bunny.net Storage API upload with different hostnames
$TestContent = "Hello from PowerShell test!"
$TestFile = "$env:TEMP\test-bunny.txt"
Set-Content -Path $TestFile -Value $TestContent

$StorageZone = "cdn-bachmann-xyz"
$ApiKey = "26489a6d-2335-4cff-8fcee4d14f90-1c72-4ea5"
$RemotePath = "test/test-upload.txt"

# Try different hostnames
$Hostnames = @(
    "https://storage.bunnycdn.com",
    "https://la.storage.bunnycdn.com", 
    "https://uk.storage.bunnycdn.com",
    "https://nyc.storage.bunnycdn.com",
    "https://sg.storage.bunnycdn.com"
)

foreach ($h in $Hostnames) {
    Write-Host "`nTrying: $h"
    $Url = "$h/$StorageZone/$RemotePath"
    
    try {
        $Response = Invoke-WebRequest -Uri $Url -Method Put -InFile $TestFile -ContentType "text/plain" -Header @{"AccessKey" = $ApiKey} -UseBasicParsing -TimeoutSec 30
        Write-Host "  Success! HTTP Status: $($Response.StatusCode)"
    } catch {
        Write-Host "  Error: $($_.Exception.Message)"
    }
}

Remove-Item $TestFile -ErrorAction SilentlyContinue
